package gov.va.med.mhv.mrp.enums;

public enum GoalCompletionTypeEnumeration {

	NOENDDATE(1, "No End Date (Ongoing)"), ENDDATE(2, "Has an End Date");

	private Integer code;
	private String description;

	private GoalCompletionTypeEnumeration(Integer code, String description) {
		this.code = code;
		this.description = description;
	}

	public static GoalCompletionTypeEnumeration findByCode(Integer code) {
		for (GoalCompletionTypeEnumeration e : GoalCompletionTypeEnumeration.values()) {
			if (e.code == code) {
				return e;
			}
		}
		// could be bad data
		return GoalCompletionTypeEnumeration.NOENDDATE;
	}

	public Integer getCode() {
		return code;
	}

	public String getDescription() {
		return description;
	}
}